/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.common.util;

import com.ibm.hsc.common.util.ExecuteBackgroundCmdListener;
import com.ibm.hsc.common.util.Trace;
import com.ibm.websm.etc.EExec;
import com.ibm.websm.etc.EExecResult;
import java.util.Enumeration;
import java.util.Hashtable;

public class ExecuteBackgroundCmd
extends Thread {
    private static final String TRACE_MASKD = "JISCCMDD";
    private static final String TRACE_MASKF = "JISCCMDF";
    private static final String TRACE_MASKT = "JISCCMDT";
    private String cmd = null;
    private Hashtable listeners = null;

    public ExecuteBackgroundCmd(String string) {
        this.cmd = string;
        this.listeners = new Hashtable();
    }

    public void run() {
        EExecResult eExecResult = null;
        Trace.trace(TRACE_MASKD, "Issuing command: " + this.cmd);
        this.notifyListeners();
        eExecResult = EExec.Exec((String)this.cmd);
        if (eExecResult.rc != 0) {
            Trace.trace(TRACE_MASKF, "Command " + this.cmd + " failed with a rc of " + eExecResult.rc + ".");
        }
        this.notifyListeners(eExecResult.rc);
    }

    public void addListener(ExecuteBackgroundCmdListener executeBackgroundCmdListener, Object object) {
        this.listeners.put(executeBackgroundCmdListener, object);
    }

    public void removeListener(ExecuteBackgroundCmdListener executeBackgroundCmdListener) {
        this.listeners.remove(executeBackgroundCmdListener);
    }

    private void notifyListeners() {
        ExecuteBackgroundCmdListener executeBackgroundCmdListener = null;
        Object var2_2 = null;
        Enumeration enumeration = this.listeners.keys();
        while (enumeration.hasMoreElements()) {
            executeBackgroundCmdListener = (ExecuteBackgroundCmdListener)enumeration.nextElement();
            var2_2 = this.listeners.get(executeBackgroundCmdListener);
            executeBackgroundCmdListener.callInitiated(this, var2_2);
        }
    }

    private void notifyListeners(int n) {
        ExecuteBackgroundCmdListener executeBackgroundCmdListener = null;
        Object var3_3 = null;
        Enumeration enumeration = this.listeners.keys();
        while (enumeration.hasMoreElements()) {
            executeBackgroundCmdListener = (ExecuteBackgroundCmdListener)enumeration.nextElement();
            var3_3 = this.listeners.get(executeBackgroundCmdListener);
            executeBackgroundCmdListener.callCompleted(this, var3_3, n);
        }
    }

    private void notifyListeners(Throwable throwable) {
        ExecuteBackgroundCmdListener executeBackgroundCmdListener = null;
        Object var3_3 = null;
        Enumeration enumeration = this.listeners.keys();
        while (enumeration.hasMoreElements()) {
            executeBackgroundCmdListener = (ExecuteBackgroundCmdListener)enumeration.nextElement();
            var3_3 = this.listeners.get(executeBackgroundCmdListener);
            executeBackgroundCmdListener.callThrowable(this, var3_3, throwable);
        }
    }
}

